﻿<?xml version="1.0" encoding="utf-8"?>
<pattern id="Mandatories" xmlns="http://purl.oclc.org/dsdl/schematron">
    <title>Mandatory Validations</title>

    <rule context="xbrli:xbrl/orgname1.02.00:OrganisationNameDetails">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.GEN.000006
        
        WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
        IF (OrganisationNameDetails.OrganisationalNameType.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000006" diagnostics="DVR.SS.GEN.000006"
            test="not(
                not(pyde.02.00:OrganisationNameDetails.OrganisationalNameType.Code[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000008
        
        WHERE IN TUPLE(orgname1.02.00:OrganisationNameDetails)
        IF (OrganisationNameDetails.OrganisationalNameType.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000008" diagnostics="DVR.SS.GEN.000008"
            test="not(
                not(pyde.02.00:OrganisationNameDetails.OrganisationalName.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />
    </rule>

    <rule context="xbrli:xbrl/prsnstrcnm1.02.00:PersonNameDetails">
        <!-- Rule ID: VR.SS.GEN.000010
        
        WHERE IN TUPLE(prsnstrcnm1.02.00:PersonNameDetails)
        IF (PersonNameDetails.FamilyName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000010" diagnostics="DVR.SS.GEN.000010"
            test="not(
                not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000011
        
        WHERE IN TUPLE(prsnstrcnm1.02.00:PersonNameDetails)
        IF (PersonNameDetails.GivenName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000011" diagnostics="DVR.SS.GEN.000011"
            test="not(
                not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />
    </rule>

    <rule context="xbrli:xbrl/prsnstrcnm3.02.01:PersonNameDetails">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.GEN.000036
        
        WHERE IN TUPLE(prsnstrcnm3.02.01:PersonNameDetails)
        IF (PersonNameDetails.FamilyName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000036" diagnostics="DVR.SS.GEN.000036"
            test="not(
                not(pyde.02.00:PersonNameDetails.FamilyName.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000037
        
        WHERE IN TUPLE(prsnstrcnm3.02.01:PersonNameDetails)
        IF (PersonNameDetails.GivenName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000037" diagnostics="DVR.SS.GEN.000037"
            test="not(
                not(pyde.02.00:PersonNameDetails.GivenName.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />
    </rule>

    <rule context="xbrli:xbrl/email1.02.00:ElectronicContactElectronicMail">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.GEN.000013
        
        WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
        IF (ElectronicContact.ElectronicMail.Usage.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000013" diagnostics="DVR.SS.GEN.000013"
            test="not(
                not(pyde.02.00:ElectronicContact.ElectronicMail.Usage.Code[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000015
        
        WHERE IN TUPLE(email1.02.00:ElectronicContactElectronicMail)
        IF (ElectronicContact.ElectronicMail.Address.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000015" diagnostics="DVR.SS.GEN.000015"
            test="not(
                not(pyde.02.00:ElectronicContact.ElectronicMail.Address.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />
    </rule>

    <rule context="xbrli:xbrl/phone1.02.00:ElectronicContactTelephone">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.GEN.000017
        
        WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.Usage.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000017" diagnostics="DVR.SS.GEN.000017"
            test="not(
                not(pyde.02.00:ElectronicContact.Telephone.Usage.Code[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000019
        
        WHERE IN TUPLE(phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.ServiceLine.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000019" diagnostics="DVR.SS.GEN.000019"
            test="not(
                not(pyde.02.00:ElectronicContact.Telephone.ServiceLine.Code[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000020
        
        WHERE IN TUPLE (phone1.02.00:ElectronicContactTelephone)
        IF (ElectronicContact.Telephone.Minimal.Number = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000020" diagnostics="DVR.SS.GEN.000020"
            test="not(
                not(pyde.02.00:ElectronicContact.Telephone.Minimal.Number[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />
    </rule>

    <rule context="xbrli:xbrl/address3.02.01:AddressDetails">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.GEN.000026
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Usage.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000026" diagnostics="DVR.SS.GEN.000026"
            test="not(
                not(pyde.02.01:AddressDetails.Usage.Code[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.GEN.000028
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Line1.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000028" diagnostics="DVR.SS.GEN.000028"
            test="not(
                not(pyde.02.00:AddressDetails.Line1.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000029
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.LocalityName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000029" diagnostics="DVR.SS.GEN.000029"
            test="not(
                not(pyde.02.00:AddressDetails.LocalityName.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.GEN.000032
        
        WHERE IN TUPLE (address3.02.01:AddressDetails)
        IF (AddressDetails.Country.Code = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.GEN.000032" diagnostics="DVR.SS.GEN.000032"
      test="not(
                not(pyde.02.08:AddressDetails.Country.Code[not(@i:nil = 'true')])
            )" />
    </rule>

    <rule context="xbrli:xbrl/sprcnt.0003.conttrans.req.02.00:FinancialInstitutionAccount">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.CCT.000061
        
        WHERE IN TUPLE (FinancialInstitutionAccount)
        IF (pyid.xx.xx:FinancialInstitutionAccount.BankStateBranch.Number = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000061" diagnostics="DVR.SS.CCT.000061"
            test="not(
                not(pyid.02.00:FinancialInstitutionAccount.BankStateBranch.Number[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.CCT.000062
        
        WHERE IN TUPLE (FinancialInstitutionAccount)
        IF (pyid.xx.xx:FinancialInstitutionAccount.FinancialInstitutionAccount.Number = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000062" diagnostics="DVR.SS.CCT.000062"
            test="not(
                not(pyid.02.20:FinancialInstitutionAccount.FinancialInstitutionAccount.Number[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.CCT.000063
        
        WHERE IN TUPLE (FinancialInstitutionAccount)
        IF (pyid.xx.xx:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text = NULLORBLANK)
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000063" diagnostics="DVR.SS.CCT.000063"
            test="not(
                not(pyid.02.00:FinancialInstitutionAccount.FinancialInstitutionAccountName.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />
    </rule>

    <rule context="xbrli:xbrl">
        <!-- Rule ID: VR.SS.CCT.000011
        
        IF COUNT(RP.SENDER:orgname1.02.00:OrganisationNameDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000011" diagnostics="DVR.SS.CCT.000011"
            test="not(
                not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::orgname1.02.00:OrganisationNameDetails])
            )" />

        <!-- Rule ID: VR.SS.CCT.000013
        
        IF COUNT(RP.SENDER:prsnstrcnm1.02.00:PersonNameDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000013" diagnostics="DVR.SS.CCT.000013"
            test="not(
                not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::prsnstrcnm1.02.00:PersonNameDetails])
            )" />

        <!-- Rule ID: VR.SS.CCT.000015
        
        IF COUNT(RP.SENDER:email1.02.00:ElectronicContactElectronicMail) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000015" diagnostics="DVR.SS.CCT.000015"
            test="not(
                not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::email1.02.00:ElectronicContactElectronicMail])
            )" />

        <!-- Rule ID: VR.SS.CCT.000017
        
        IF COUNT(RP.SENDER:phone1.02.00:ElectronicContactTelephone) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000017" diagnostics="DVR.SS.CCT.000017"
            test="not(
                not(key('contextDetailsById', $RP.MessageSender.ContextId)[self::phone1.02.00:ElectronicContactTelephone])
            )" />

        <!-- Rule ID: VR.SS.CCT.000019
        
        IF COUNT(RP.RECEIVER:orgname1.02.00:OrganisationNameDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000019" diagnostics="DVR.SS.CCT.000019"
            test="not(
                not(key('contextDetailsById', $RP.MessageReceiver.ContextId)[self::orgname1.02.00:OrganisationNameDetails])
            )" />

        <!-- Rule ID: VR.SS.CCT.000022
        
        IF COUNT(RP.PAYER:orgname1.02.00:OrganisationNameDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000022" diagnostics="DVR.SS.CCT.000022"
            test="not(
                not(key('contextDetailsById', $RP.Payer.ContextId)[self::orgname1.02.00:OrganisationNameDetails])
            )" />

        <!-- Rule ID: VR.SS.CCT.000024
        
        IF COUNT(RP.PAYER:sprcnt.0003.conttrans.req.02.00:FinancialInstitutionAccount) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000024" diagnostics="DVR.SS.CCT.000024"
            test="not(
                not(key('contextDetailsById', $RP.Payer.ContextId)[self::sprcnt.0003.conttrans.req.02.00:FinancialInstitutionAccount])
            )" />

        <!-- Rule ID: VR.SS.CCT.000026
        
        IF COUNT(Payee:pyin.xx.xx:PaymentMechanism.PaymentMethod.Code) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000026" diagnostics="DVR.SS.CCT.000026"
            test="not(
                not(key('contextDetailsById', $RP.Payee.ContextId)[self::pyin.02.67:PaymentMechanism.PaymentMethod.Code[not(@i:nil='true')]])
            )" />

        <!-- Rule ID: VR.SS.CCT.000032
        
        IF Payee:pyin.xx.xx:PaymentRecord.Payment.Amount = NULL
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000032" diagnostics="DVR.SS.CCT.000032"
            test="not(
                not(key('contextDetailsById', $RP.Payee.ContextId)[self::pyin.02.00:PaymentRecord.Payment.Amount[not(@i:nil='true')]])
            )" />
    
        <!-- Rule ID: VR.SS.CCT.000035
        
        IF COUNT(RP.EMPLOYER:orgname1.02.00:OrganisationNameDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000035" diagnostics="DVR.SS.CCT.000035"
            test="not(
                not(key('contextDetailsById', $RP.Employer.ContextId)[self::orgname1.02.00:OrganisationNameDetails])
            )" />
    </rule>

    <rule context="xbrli:xbrl/xbrli:context[generate-id() = $RP.SuperFundMember.Context/generate-id()]">
        <let name="thisContextId" value="@id"/>

        <!-- Rule ID: VR.SS.CCT.000037
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF COUNT(RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000037" diagnostics="DVR.SS.CCT.000037"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails[not(@i:nil = 'true')]])
            )" />

        <!-- Rule ID: VR.SS.CCT.000039
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails/pyde.02.00:PersonNameDetails.PersonNameType.Code  = NULL
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000039" diagnostics="DVR.SS.CCT.000039"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.00:PersonNameDetails.PersonNameType.Code[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.CCT.000041
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails/pyde.02.05:PersonNameDetails.Usage.Code = NULL
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000041" diagnostics="DVR.SS.CCT.000041"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.05:PersonNameDetails.Usage.Code[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.CCT.000043
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:prsnstrcnm3.02.01:PersonNameDetails/pyde.02.00:PersonNameDetails.Currency.Code = NULL
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000043" diagnostics="DVR.SS.CCT.000043"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::prsnstrcnm3.02.01:PersonNameDetails]/pyde.02.00:PersonNameDetails.Currency.Code[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.CCT.000045
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF COUNT(RP.SUPERFUNDMEMBER:address3.02.01:AddressDetails) = 0
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000045" diagnostics="DVR.SS.CCT.000045"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::address3.02.01:AddressDetails[not(@i:nil = 'true')]])
            )" />

        <!-- Rule ID: VR.SS.CCT.000049
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:emsup.02.08:SuperannuationContribution.PayPeriodStart.Date = NULL
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000049" diagnostics="DVR.SS.CCT.000049"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationContribution.PayPeriodStart.Date[not(@i:nil = 'true')]])
            )" />

        <!-- Rule ID: VR.SS.CCT.000050
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:emsup.02.08:SuperannuationContribution.PayPeriodEnd.Date = NULL
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000050" diagnostics="DVR.SS.CCT.000050"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::emsup.02.08:SuperannuationContribution.PayPeriodEnd.Date[not(@i:nil = 'true')]])
            )" />
    
        <!-- Rule ID: VR.SS.CCT.000057
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator = NULLORBLANK
             RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000057" diagnostics="DVR.SS.CCT.000057"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::pyid.02.05:Identifiers.TaxFileNumberNotProvided.Indicator[not(@i:nil = 'true')]])
            )" />

        <!-- Rule ID: VR.SS.CCT.000058
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:pyde.02.18:PersonDemographicDetails.Sex.Code = NULLORBLANK
             RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000058" diagnostics="DVR.SS.CCT.000058"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::pyde.02.18:PersonDemographicDetails.Sex.Code[not(@i:nil = 'true')]])
            )" />

        <!-- Rule ID: VR.SS.CCT.000059
        
        FOR ANY OCCURRENCE OF CONTEXT (RP.SUPERFUNDMEMBER)
        IF RP.SUPERFUNDMEMBER:pyde.02.00:PersonDemographicDetails.Birth.Date = NULLORBLANK
             RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000059" diagnostics="DVR.SS.CCT.000059"
            test="not(
                not(key('contextDetailsById', $thisContextId)[self::pyde.02.00:PersonDemographicDetails.Birth.Date[not(@i:nil = 'true')]])
            )" />
    </rule>

    <rule context="xbrli:xbrl/sprcnt.0003.conttrans.req.02.00:SuperannuationContributionOtherAmounts">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.CCT.000051
        
        WHERE IN TUPLE (sprcnt.0003.conttrans.req.02.00:SuperannuationContributionOtherAmounts)
        IF RP.SUPERFUNDMEMBER:emsup.02.08:SuperannuationContribution.Other.Amount) = NULLORBLANK
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000051" diagnostics="DVR.SS.CCT.000051"
            test="not(
                not(emsup.02.08:SuperannuationContribution.Other.Amount[not(@i:nil = 'true')])
            )" />

        <!-- Rule ID: VR.SS.CCT.000052
        
        WHERE IN TUPLE (sprcnt.0003.conttrans.req.02.00:SuperannuationContributionOtherAmounts)
        IF RP.SUPERFUNDMEMBER:emsup.02.08:SuperannuationContribution.Other.Description) = NULLORBLANK
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000052" diagnostics="DVR.SS.CCT.000052"
            test="not(
                not(emsup.02.08:SuperannuationContribution.Other.Description[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

    </rule>

    <rule context="xbrli:xbrl/sprcnt.0003.conttrans.req.02.00:SuperannuationContributionOtherDetails">
        <let name="thisContextId" value="./*[1]/@contextRef"/>

        <!-- Rule ID: VR.SS.CCT.000053
        
        WHERE IN TUPLE (sprcnt.0003.conttrans.req.02.00:SuperannuationContributionOtherAmounts)
        IF RP.SUPERFUNDMEMBER:emsup.02.08:SuperannuationContribution.OtherDetails.Text) = NULLORBLANK
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000053" diagnostics="DVR.SS.CCT.000053"
            test="not(
                not(emsup.02.08:SuperannuationContribution.OtherDetails.Text[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />

        <!-- Rule ID: VR.SS.CCT.000054
        
        WHERE IN TUPLE (sprcnt.0003.conttrans.req.02.00:SuperannuationContributionOtherAmounts)
        IF RP.SUPERFUNDMEMBER:emsup.02.08:SuperannuationContribution.OtherDetails.Description) = NULLORBLANK
            RETURN VALIDATION MESSAGE
        END IF
        -->
        <assert id="VR.SS.CCT.000054" diagnostics="DVR.SS.CCT.000054"
            test="not(
                not(emsup.02.08:SuperannuationContribution.OtherDetails.Description[not(@i:nil = 'true' or string-length(.) = 0)])
            )" />
    
    </rule>
</pattern>
